﻿/* Skript zur Demonstration von Datumsfunktionen
 * Als Benutzer SCOTT ausführen
 */
 
-- Unterschiede in der Ausgabe mit Zeitzonen
alter session set time_zone = 'America/Chicago';
alter session set nls_date_format = 'dd.mm.yyyy hh24:mi:ss';

-- Liste der verfügbaren Zeitzonen
select distinct substr(tzname, 1, instr(tzname, '/')) country, tzabbrev
  from v$timezone_names;
  
-- Liste der Zeitzonenkürzel, die direkt ausgewählt werden können
select *
  from v$timezone_names
 where tzname = tzabbrev;
 
-- Anweisungen zum Ändern der Zeitzone
alter session set time_zone = dbtimezone;
alter session set time_zone = local;
alter session set time_zone = 'Europe/Berlin';
alter session set time_zone = '+06:30';
 
-- Erste Abfrage über den DATE
select sysdate, current_date
  from dual;
  
select systimestamp, current_timestamp, localtimestamp
  from dual;

-- Ausgabe der Datenbank- und Sessionzeitzone
select dbtimezone, sessiontimezone
  from dual;

-- Erzeugung eines timestamps with time zone mit Literalen
select timestamp '2012-03-26 15:30:00 CET' zeitstempel
  from dual;
  
select timestamp '2012-03-26 15:30:00 -05:30' zeitstempel
  from dual;
  
select timestamp '2012-03-26 15:30:00' at time zone 'CST' zeitstempel
  from dual;
  
-- Verwendung des Parameters nls_date_language bei Konvertierungsfunktionen
select to_char(sysdate, 'Day') deutsch,
       to_char(sysdate, 'Day', 'nls_date_language=AMERICAN') englisch
  from dual;
  
/* Zeilenfunktionen zur Bearbeitung von Zeitzonen */
-- DBTIMEZONE, SESSIONTIMEZONE
select dbtimezone, sessiontimezone
  from dual;
  
-- FROM_TZ zur Überführung von timestamp in timestamp with time zone
select from_tz(localtimestamp, 'America/Chicago') ts_with_tz
  from dual;
select from_tz(localtimestamp, '-07:30') ts_with_tz
  from dual;
  
-- NEW_TIME zur Überführung eines Datums in eine andere Zeitzone (liefert date)
select localtimestamp,
       new_time(localtimestamp, 'GMT', 'EST') new_date
  from dual;

select sysdate,
       new_time(sysdate, 'GMT', 'EST') new_date
  from dual;
  
-- SYS_EXTRACT_UTC zur Extraktion von UTC aus timestamp with time zone
select sys_extract_utc(
         timestamp '2012-05-15 15:30:00 America/Chicago') utc_time
  from dual;
  
-- TZ_OFFSET Differenz zu UTC
select tz_offset('US/Eastern') offset
  from dual;
  
select tz_offset(dbtimezone) offset
  from dual;
  
select tz_offset(sessiontimezone) offset
  from dual;
  
select tz_offset('UTC') offset
  from dual;